/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: PNIOEDD_Functionlist.h $
   Last Modification:
    $Author: Benjamin $
    $Modtime: 17.03.08 16:10 $
    $Revision: 2 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    PNIO EDD
    Task function list for configuration file

   Changes:

     Version    Date        Author   Description
     ---------------------------------------------------------------------------
     2          2008-03-17  bm       changed  STARTUP_PARAM_VERSION  to 2
                                     renamed parameter  "ulDummy"  to  ulMaxIODevCnt

     1          ---         mg       initial version

**************************************************************************************/
/**
 * @file PNIOEDD_Functionlist.h
 * @brief PNIO EDD - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_PNM_PNIOEDD</code>
 * of task.
 */
#ifndef __PNM_PNIO_EDD_FUNCTIONLIST_H
#define __PNM_PNIO_EDD_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_PNM_PNIOEDD
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskEnter_PNM_PNIOEDD
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define PNIO_EDD_STARTUP_PARAM_VERSION_V2 (2)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct PNM_PNIO_EDD_STARTUPPARAMETER_Ttag  PNM_PNIO_EDD_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct PNM_PNIO_EDD_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_UINT32    ulTaskIdentifier;
  TLR_UINT32    ulParamVersion;

  /** maximum number of supported IO-Devices */
  TLR_UINT32  ulMaxIODevCnt;
};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __PNM_PNIO_EDD_FUNCTIONLIST_H */
